# One Task per Resource
# Copyright 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 080510 - first version based on One Task per Resource in Project
# 080513 - Alex - remove redundant dependencies, slight refactoring

debug = 0

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def RemovePrerequisitesForTask(taskid, reason):
    prereqs = Data.SearchByColumn(Data.Dependency,
                                  {'TaskID': taskid, 'Reason': reason})
    for k in prereqs:
        change = {'Table': 'Dependency',
                  'ID': k,
                  'Reason': None,
                  'zzStatus': 'deleted',
                 }
        Data.Update(change)

def RemoveDependencies(projectid, reason):
    if debug: print "projectid %s, reason %s" % (projectid, reason)
    dd = Data.Database['Dependency']
    dt = Data.Database['Task']
    for k, v in dd.iteritems():
        if v.get('Reason') != reason: continue
        tid, pid = v.get('TaskID'), v.get('PrerequisiteID')
        if tid not in dt or pid not in dt: continue
        if (dt[tid].get('ProjectID') == projectid
##            and  # prerequisite doesn't have to be in this project
##            dt[pid].get('ProjectID') == projectid
            ):
            change = { 'Table': 'Dependency',
                       'ID': k,
                       'Reason': None,
                       'zzStatus': 'deleted',
                       }
            Data.Update(change)

def BuildOtherProjectList(projectid):
    '''Builds a list of task ids
    Includes all tasks w/ lower shedule priority numbers
        that shouldn't be finished before the project begins.
    '''
    dp = Data.Database['Project']
    dt = Data.Database['Task']
    priority = dp[projectid].get('SchedulePriority')
    try:
        priority_number = int(priority)
    except TypeError:
        priority_number = -1
    priority_projects = []
    for k, v in dp.iteritems():
        if k == 1 or k == projectid: continue  # other projects only
        if v.get('zzStatus') == 'deleted': continue
        other_priority = v.get('SchedulePriority')
        try:
            other_number = int(other_priority)
        except TypeError:
            other_number = -1
        if priority_number == -1:  # no priority for this project
            if v.get('SchedulePriority'):  # give precedence to all projects w/ a priority number
                priority_projects.append(k)
        else:  # give priority to all projects w/ lower numbers
            if 0 < other_number < priority_number:
                priority_projects.append(k)
    if debug: print "priority_projects", priority_projects
    earliest_start = None  # find out when the earliest task is schedule to start
    for k, v in dt.iteritems():
        if v.get('ProjectID') != projectid: continue
        if v.get('zzStatus') == 'deleted': continue
        if earliest_start == None or earliest_start > v.get('hES'):
            earliest_start == v.get('hES')
    result = []  # tasks in priority projects and not completed before project begins
    for k, v in dt.iteritems():
        if v.get('ProjectID') not in priority_projects: continue
        if v.get('zzStatus') == 'deleted': continue
        if earliest_start < v.get('hEF'):
            result.append(( v.get('hES'), v.get('hEF'),k))
    if debug: print "otherlist", repr(result)
    return result

def BuildWorkList(reportid):
    dr = Data.Database['ReportRow']
    dt = Data.Database['Task']
    result = []
    rows = Data.GetRowList(reportid)
    for i, row in enumerate(rows):
        if dr[row].get('TableName') != 'Task': continue  # only task rows
        tid = dr[row].get('TableID')
        if tid not in dt: continue
        if 'SubtaskCount' in dt[tid]: continue  # skip parent tasks
        es = dt[tid].get('hES')
        if es == None: continue  # should always be non-null
        result.append((es, i, tid))
    return result

def UpdateOtherList(oldlist):
    dt = Data.Database['Task']
    result = []
    for oldes, oldef, tid in oldlist:
        es = dt[tid].get('hES')
        ef = dt[tid].get('hEF')
        result.append((es, ef, tid))
    return result

def UpdateWorkList(oldlist):
    dt = Data.Database['Task']
    result = []
    for oldes, i, tid in oldlist:
        es = dt[tid].get('hES')
        result.append((es, i, tid))
    return result

def GetResourceIDs(taskid):
    dr = Data.Database['Resource']
    matches = Data.SearchByColumn(Data.Database['Assignment'],
                        {'TaskID': taskid, })
    return [ v.get('ResourceID') for k, v in matches.iteritems()
             if v.get('zzStatus') != 'deleted'  # assignment record not deleted
             and v.get('ResourceID') in dr  # resource record not deleted
             and dr[v.get('ResourceID')].get('zzStatus') != 'deleted']

# Alex: should we add this to Data.py?
def AddDependency(task1, task2, reason=None):
    if debug: print "adding dependency from %s to %s" % (task1, task2)
    dd = Data.Database['Dependency']
    match = Data.SearchByColumn(dd,
                                {'PrerequisiteID': task1,
                                 'TaskID': task2,
                                 }, unique=True)
    change = {'Table': 'Dependency',
              'PrerequisiteID': task1,
              'TaskID': task2,
              'Reason': reason,
              }
    if match:
        change['ID'] = match
        if dd[match].get('zzStatus') == 'deleted':
            change['zzStatus'] = None
    Data.Update(change)

def Overlap(resourcesA, resourcesB):
    test = {}
    for x in resourcesA:
        test[x] = None
    for x in resourcesB:
        test[x] = None
    return len(test) != len(resourcesA) + len(resourcesB)

def RemoveOverlap(self):
# algorithm:
# sort tasks by start hour, report row #, task id
# take the earliest task
# for each task in our list of prior commitments (otherlist)
#     if that task starts before this one ends
#     and ends after this one starts
#     and has any of the same people working on it
#         remove any previous OTRP dependencies
#         add a dependency between that task and this one
#         recalculate the critical path
#         start over with the new earliest task
# if no overlaps were found
#     remove this task from the list
#     and add it to our list of commitments

    # create short cuts to all of the tables used
    dp = Data.Database['Project']
    dt = Data.Database['Task']

    reportid = self.ReportID  # current report
    pid = Data.Database['Report'][reportid].get('ProjectID')
    if pid not in dp: return
    
    RemoveDependencies(pid, "otrp")  # one task per resource in project
    Data.GanttCalculation()
    otherlist = BuildOtherProjectList(pid)
    otherlist.sort()
    worklist = BuildWorkList(reportid)
    worklist.sort()
    count = 0
    while worklist:
        es, row, taskid = worklist[0]
        resourcesA = GetResourceIDs(taskid)
        task = dt[taskid]
        ef = task.get('hEF', es)  # should always be there

        # delete other tasks if they finish before the remaining worklist tasks
        while otherlist and otherlist[0][1] < es:
            del otherlist[0]
            
        # if a resource needed by this task is needed by an overlapping
        #   otherlist task
        #   wait to start this task until after that other task is finished

        okay = True
        i = 0
        while (i < len(otherlist)):  # more remaining that could be checked
            other_es, other_ef, other_id = otherlist[i]
            if debug: "task, other", taskid, other_id
            if debug: "es, ef", es, ef
            if debug: "oes, oef", other_es, other_ef
            if debug:
                if es < other_ef and other_es < ef:
                    print "overlap"
                else:
                    print "not overlap"
            if ef < other_es: break #  none of the remaining could overlap
            #      es------------ef
            #  oes--oef oes-oef oes-oef
            if es < other_ef and other_es < ef:  # they overlap
                resourcesB = GetResourceIDs(other_id)
                if Overlap(resourcesA, resourcesB):
                    okay = False  # overlapping tasks use same resource
                    RemovePrerequisitesForTask(taskid, 'otrp')
                    AddDependency(other_id, taskid, 'otrp')
                    break
            i += 1
        if okay:
            # this task is compatible with all our prior commitments
            # add it to our list of commitments
            del worklist[0]
            otherlist.append((es, ef, taskid))
            otherlist.sort()
        else:
            Data.GanttCalculation()
            worklist = UpdateWorkList(worklist)  # with new start times
            worklist.sort()
            otherlist = UpdateOtherList(otherlist)  # with new start times
            otherlist.sort()
#            continue

        # if a second task in this project would like to use one of
        #   the resources before this task is finished
        #   have that second task wait until this task is finished 

#        okay = True
#        i = 1
#        while i < len(worklist) and dt[worklist[i][2]].get('hES') < ef:  # overlapping tasks
#            resourcesB = GetResourceIDs(worklist[i][2])
#            if Overlap(resourcesA, resourcesB):
#                okay = False  # overlapping tasks use same resource
#                AddDependency(taskid, worklist[i][2], 'otrp')
#                break
#            i += 1
#        if okay:
#            del worklist[0]
#        else:
#            Data.GanttCalculation()
#            worklist = UpdateWorkList(worklist)  # with new start times
#            worklist.sort()

        count += 1
        if count > 2000:
            print "loop error - count %s" % count
            break

    Data.SetUndo('One Task per Resource by Schedule Priority')

RemoveOverlap(self)
